<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_DataWriter_DiscussionMessage_ProfilePost extends XFCP_sonnbStopSpamHere_DataWriter_DiscussionMessage_ProfilePost
{

    protected function _messagePreSave()
    {
        parent::_messagePreSave();
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_MODERATE]))
        {
            $this->set('message_state', 'moderated');
        }
        
    }
    
    protected function _messagePostSave()
    {
        parent::_messagePostSave();
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_MODERATE]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_MODERATE]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_MODERATE,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_MODERATE]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_MODERATE]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_ALLOW]))
        {
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_ALLOW]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_ALLOW,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_ALLOW]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_ALLOW]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_CONVERSATION]))
        {
            sonnbStopSpamHere_Model_Moderate::sendPC(
                XenForo_Visitor::getInstance(),
                XenForo_Link::buildPublicLink('profile-posts', array('profile_post_id' => $this->get('profile_post_id'))),
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_CONVERSATION]
            );
            
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_CONVERSATION]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_CONVERSATION,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_CONVERSATION]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_CONVERSATION]);
        }
        
        if (isset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_REPORT]))
        {            
            sonnbStopSpamHere_Model_Moderate::sendReport(
                'profile_post',
                array(
                    'profile_post_id' => $this->get('profile_post_id'),
                    'user_id' => $this->get('user_id')
                ),
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_REPORT]
            );
            
            $this->addLog(
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_REPORT]['type'], 
                sonnbStopSpamHere_Model_SSH::ACTION_REPORT,
                $GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_REPORT]['data']
            );
            
            unset($GLOBALS[sonnbStopSpamHere_Global::SONNB_SSH_PROFILEPOST_REPORT]);
        }
        
    }
    
    public function addLog($type, $action, array $data = array())
    {
        $sshModel = new sonnbStopSpamHere_Model_SSH;
        $sshModel->saveLog(
            array(
                'content_type' => sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST,
                'content_id' => $this->get('profile_post_id'),
                'log_type' => $type,
                'data' => serialize($data),
                'action' => $action
            )
        );
    }
}